library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity character_rom is
  
  port (
    addr : in  unsigned(8 downto 0);
    clk  : in  std_logic;
    dout : out unsigned(4 downto 0));
end character_rom;

architecture rtl of character_rom is
  type rom_array is array (0 to 511) of unsigned(4 downto 0);

  constant ROM : rom_array := (
    "01110",
    "10001",
    "10101",
    "11101",
    "01101",
    "00001",
    "11110",
    "00000",
    "00100",
    "01010",
    "10001",
    "10001",
    "11111",
    "10001",
    "10001",
    "00000",
    "01111",
    "10001",
    "10001",
    "01111",
    "10001",
    "10001",
    "01111",
    "00000",
    "01110",
    "10001",
    "00001",
    "00001",
    "00001",
    "10001",
    "01110",
    "00000",
    "01111",
    "10001",
    "10001",
    "10001",
    "10001",
    "10001",
    "01111",
    "00000",
    "11111",
    "00001",
    "00001",
    "01111",
    "00001",
    "00001",
    "11111",
    "00000",
    "11111",
    "00001",
    "00001",
    "01111",
    "00001",
    "00001",
    "00001",
    "00000",
    "11110",
    "00001",
    "00001",
    "00001",
    "11001",
    "10001",
    "11110",
    "00000",
    "10001",
    "10001",
    "10001",
    "11111",
    "10001",
    "10001",
    "10001",
    "00000",
    "01110",
    "00100",
    "00100",
    "00100",
    "00100",
    "00100",
    "01110",
    "00000",
    "10000",
    "10000",
    "10000",
    "10000",
    "10000",
    "10001",
    "01110",
    "00000",
    "10001",
    "01001",
    "00101",
    "00011",
    "00101",
    "01001",
    "10001",
    "00000",
    "00001",
    "00001",
    "00001",
    "00001",
    "00001",
    "00001",
    "11111",
    "00000",
    "10001",
    "11011",
    "10101",
    "10101",
    "10001",
    "10001",
    "10001",
    "00000",
    "10001",
    "10001",
    "10011",
    "10101",
    "11001",
    "10001",
    "10001",
    "00000",
    "01110",
    "10001",
    "10001",
    "10001",
    "10001",
    "10001",
    "01110",
    "00000",
    "01111",
    "10001",
    "10001",
    "01111",
    "00001",
    "00001",
    "00001",
    "00000",
    "01110",
    "10001",
    "10001",
    "10001",
    "10101",
    "01001",
    "10110",
    "00000",
    "01111",
    "10001",
    "10001",
    "01111",
    "00101",
    "01001",
    "10001",
    "00000",
    "01110",
    "10001",
    "00001",
    "01110",
    "10000",
    "10001",
    "01110",
    "00000",
    "11111",
    "00100",
    "00100",
    "00100",
    "00100",
    "00100",
    "00100",
    "00000",
    "10001",
    "10001",
    "10001",
    "10001",
    "10001",
    "10001",
    "01110",
    "00000",
    "10001",
    "10001",
    "10001",
    "10001",
    "10001",
    "01010",
    "00100",
    "00000",
    "10001",
    "10001",
    "10001",
    "10101",
    "10101",
    "11011",
    "10001",
    "00000",
    "10001",
    "10001",
    "01010",
    "00100",
    "01010",
    "10001",
    "10001",
    "00000",
    "10001",
    "10001",
    "01010",
    "00100",
    "00100",
    "00100",
    "00100",
    "00000",
    "11111",
    "10000",
    "01000",
    "00100",
    "00010",
    "00001",
    "11111",
    "00000",
    "11111",
    "00011",
    "00011",
    "00011",
    "00011",
    "00011",
    "11111",
    "00000",
    "00000",
    "00001",
    "00010",
    "00100",
    "01000",
    "10000",
    "00000",
    "00000",
    "11111",
    "11000",
    "11000",
    "11000",
    "11000",
    "11000",
    "11111",
    "00000",
    "00000",
    "00000",
    "00100",
    "01010",
    "10001",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "11111",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00100",
    "00100",
    "00100",
    "00100",
    "00100",
    "00000",
    "00100",
    "00000",
    "01010",
    "01010",
    "01010",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "01010",
    "01010",
    "11111",
    "01010",
    "11111",
    "01010",
    "01010",
    "00000",
    "00100",
    "11110",
    "00101",
    "01110",
    "10100",
    "01111",
    "00100",
    "00000",
    "00011",
    "10011",
    "01000",
    "00100",
    "00010",
    "11001",
    "11000",
    "00000",
    "00010",
    "00101",
    "00101",
    "00010",
    "10101",
    "01001",
    "10110",
    "00000",
    "00100",
    "00100",
    "00100",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00100",
    "00010",
    "00001",
    "00001",
    "00001",
    "00010",
    "00100",
    "00000",
    "00100",
    "01000",
    "10000",
    "10000",
    "10000",
    "01000",
    "00100",
    "00000",
    "00100",
    "10101",
    "01110",
    "00100",
    "01110",
    "10101",
    "00100",
    "00000",
    "00000",
    "00100",
    "00100",
    "11111",
    "00100",
    "00100",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00100",
    "00100",
    "00010",
    "00000",
    "00000",
    "00000",
    "00000",
    "11111",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00100",
    "00000",
    "00000",
    "10000",
    "01000",
    "00100",
    "00010",
    "00001",
    "00000",
    "00000",
    "01110",
    "10001",
    "11001",
    "10101",
    "10011",
    "10001",
    "01110",
    "00000",
    "00100",
    "00110",
    "00100",
    "00100",
    "00100",
    "00100",
    "01110",
    "00000",
    "01110",
    "10001",
    "10000",
    "01100",
    "00010",
    "00001",
    "11111",
    "00000",
    "11111",
    "10000",
    "01000",
    "01100",
    "10000",
    "10001",
    "01110",
    "00000",
    "01000",
    "01100",
    "01010",
    "01001",
    "11111",
    "01000",
    "01000",
    "00000",
    "11111",
    "00001",
    "01111",
    "10000",
    "10000",
    "10001",
    "01110",
    "00000",
    "11100",
    "00010",
    "00001",
    "01111",
    "10001",
    "10001",
    "01110",
    "00000",
    "11111",
    "10000",
    "01000",
    "00100",
    "00010",
    "00010",
    "00010",
    "00000",
    "01110",
    "10001",
    "10001",
    "01110",
    "10001",
    "10001",
    "01110",
    "00000",
    "01110",
    "10001",
    "10001",
    "11110",
    "10000",
    "01000",
    "00111",
    "00000",
    "00000",
    "00000",
    "00100",
    "00000",
    "00100",
    "00000",
    "00000",
    "00000",
    "00000",
    "00000",
    "00100",
    "00000",
    "00100",
    "00100",
    "00010",
    "00000",
    "01000",
    "00100",
    "00010",
    "00001",
    "00010",
    "00100",
    "01000",
    "00000",
    "00000",
    "00000",
    "11111",
    "00000",
    "11111",
    "00000",
    "00000",
    "00000",
    "00010",
    "00100",
    "01000",
    "10000",
    "01000",
    "00100",
    "00010",
    "00000",
    "01110",
    "10001",
    "01000",
    "00100",
    "00100",
    "00000",
    "00100",
    "00000");

begin

  process (clk)
  begin
    if rising_edge(clk) then
      dout <= ROM(TO_INTEGER(addr));
    end if;
  end process;

end rtl;
